document.addEventListener('DOMContentLoaded', () => {
  const toggle = document.querySelector('.hamburger-toggle');
  const menu = document.querySelector('.nav-mobile');
  if (!toggle || !menu) return;

  let isOpen = false;

  function openMenu() {
    toggle.classList.add('active');
    menu.classList.add('active');
    toggle.setAttribute('aria-expanded', 'true');
    menu.setAttribute('aria-hidden', 'false');
    isOpen = true;
  }

  function closeMenu() {
    toggle.classList.remove('active');
    menu.classList.remove('active');
    toggle.setAttribute('aria-expanded', 'false');
    menu.setAttribute('aria-hidden', 'true');
    isOpen = false;
  }

  function toggleMenu() { (isOpen ? closeMenu : openMenu)(); }

  toggle.addEventListener('click', (e) => { e.preventDefault(); toggleMenu(); });
  document.addEventListener('click', (e) => {
    if (!toggle.contains(e.target) && !menu.contains(e.target)) closeMenu();
  });
  document.addEventListener('keydown', (e) => { if (e.key === 'Escape' && isOpen) closeMenu(); });
  menu.querySelectorAll('a').forEach((a) => a.addEventListener('click', closeMenu));
});



